Attribute VB_Name = "Module2"
Option Explicit

Private Declare Function SetWindowsHookEx Lib "user32" Alias "SetWindowsHookExA" (ByVal idHook As Long, ByVal lpfn As Long, ByVal hmod As Long, ByVal dwThreadId As Long) As Long
Private Declare Function UnhookWindowsHookEx Lib "user32" (ByVal hHook As Long) As Long
Private Declare Function CallNextHookEx Lib "user32" (ByVal hHook As Long, ByVal ncode As Long, ByVal wParam As Long, lParam As Any) As Long
'Private Declare Function GetTickCount Lib "kernel32" () As Long
'Private Declare Function GetAsyncKeyState Lib "user32" (ByVal vKey As Long) As Integer
'Private Declare Function GetCurrentThreadId Lib "kernel32" () As Long


Public Const WH_CALLWNDPROC = 4
Public Const WH_CALLWNDPROCRET = 12
Public Const WH_CBT = 5
Public Const WH_DEBUG = 9
Public Const WH_FOREGROUNDIDLE = 11
Public Const WH_GETMESSAGE = 3
Public Const WH_HARDWARE = 8
Public Const WH_JOURNALPLAYBACK = 1
Public Const WH_JOURNALRECORD = 0
Public Const WH_KEYBOARD = 2
Public Const WH_MAX = 11
Public Const WH_MIN = (-1)
Public Const WH_MOUSE = 7
Public Const WH_MSGFILTER = (-1)
Public Const WH_SHELL = 10
Public Const WH_SYSMSGFILTER = 6

Public Const MSGF_DIALOGBOX = 0
Public Const MSGF_NEXTWINDOW = 6
Public Const MSGF_SCROLLBAR = 5
Public Const MSGF_MENU = 2

Public Const MSGF_MAINLOOP = 8      'Not used with MsgFilter Hook
Public Const MSGF_MAX = 8           'Not used with MsgFilter Hook
Public Const MSGF_MESSAGEBOX = 1    'Not used with MsgFilter Hook
Public Const MSGF_MOVE = 3          'Not used with MsgFilter Hook
Public Const MSGF_SIZE = 4          'Not used with MsgFilter Hook
Public Const MSGF_DDEMGR = &H8001   'Not used with MsgFilter Hook
Public Const MSGF_USER = 4096       'Not used with MsgFilter Hook


Private Const HC_ACTION = 0
Private Const HC_GETNEXT = 1
Private Const HC_SKIP = 2
Private Const HC_NOREMOVE = 3
Private Const HC_NOREM = HC_NOREMOVE
Private Const HC_SYSMODALOFF = 5
Private Const HC_SYSMODALON = 4

Public Const HSHELL_ACTIVATESHELLWINDOW = 3
Public Const HSHELL_WINDOWCREATED = 1
Public Const HSHELL_WINDOWDESTROYED = 2
'public const HSHELL_APPCOMMAND = ???
' #if(WINVER >= 0x0400)
Public Const HSHELL_WINDOWACTIVATED = 4
Public Const HSHELL_GETMINRECT = 5
Public Const HSHELL_REDRAW = 6
Public Const HSHELL_TASKMAN = 7
Public Const HSHELL_LANGUAGE = 8
' #if(_WIN32_WINNT >= 0x0500)
Public Const HSHELL_ACCESSIBILITYSTATE = 11
Public Const ACCESS_STICKYKEYS = &H1
Public Const ACCESS_FILTERKEYS = &H2
Public Const ACCESS_MOUSEKEYS = &H3

Public Const HCBT_ACTIVATE = 5
Public Const HCBT_CLICKSKIPPED = 6
Public Const HCBT_CREATEWND = 3
Public Const HCBT_DESTROYWND = 4
Public Const HCBT_KEYSKIPPED = 7
Public Const HCBT_MINMAX = 1
Public Const HCBT_MOVESIZE = 0
Public Const HCBT_QS = 2
Public Const HCBT_SETFOCUS = 9
Public Const HCBT_SYSCOMMAND = 8


Public Type DEBUGHOOKINFO
        hModuleHook As Long
        Reserved As Long
        lParam As Long
        wParam As Long
        code As Long
End Type

Public Type POINTAPI
        x As Long
        y As Long
End Type

Public Type MSG
    hwnd As Long
    message As Long
    wParam As Long
    lParam As Long
    time As Long
    pt As POINTAPI
End Type

Public Type CWPSTRUCT
        lParam As Long
        wParam As Long
        message As Long
        hwnd As Long
End Type

Public Type CWPRETSTRUCT
        lResult As Long
        lParam As Long
        wParam As Long
        message As Long
        hwnd As Long
End Type

Public Type RECT
        Left As Long
        Top As Long
        Right As Long
        Bottom As Long
End Type

Public Type CREATESTRUCT
        lpCreateParams As Long
        hInstance As Long
        hMenu As Long
        hWndParent As Long
        cy As Long
        cx As Long
        y As Long
        x As Long
        style As Long
        lpszName As String
        lpszClass As String
        ExStyle As Long
End Type

Public Type CBT_CREATEWND
        lpcs As CREATESTRUCT
        hWndInsertAfter As Long
End Type

Public Type CBTACTIVATESTRUCT
        fMouse As Long
        hWndActive As Long
End Type

Public Type MOUSEHOOKSTRUCT
        pt As POINTAPI
        hwnd As Long
        wHitTestCode As Long
        dwExtraInfo As Long
End Type


'WINUSER.H contains all these constants, structs, etc...
'WINABLE.H more info on hooks
'
'See WinEvents in the MSDN for more info


Private lpPrevWndProc As Long
Private lpPrevDBGWndProc As Long

Public IsHooked As Boolean
Public IsDBGHooked As Boolean




'-----------------------------
' SET MESSAGE FILTER HOOK
'-----------------------------
Public Sub SetCBTHook()
    If IsHooked Then
        MsgBox "Don't hook CBT twice without unhooking, or you will be unable to unhook it."
    Else
        'IF you use (xx, app.hinstance, 0) instead of (xx, 0, app.threadid) then you are
        '   hooking the entire desktop and not just this thread.  When it crashes all apps
        '   will be taken down as a result because the hook has been injected into every
        '   app running on the desktop.
        '
        '??? WHY can I substitute App.hInstance for the 0 in the hInstance parameter and the app functions the same ???
        lpPrevWndProc = SetWindowsHookEx(WH_CBT, AddressOf CBTProc, 0, App.ThreadID)

        IsHooked = True
        
        
        'PROBLEM: FIXED by using app.hinstance
        'A global hook is being set with a NULL hInstance parameter
        '   or a thread-specific hook is being set for a thread
        '   that is not in the setting application.
    End If
End Sub

Public Sub RemoveCBTHook()
    Dim temp As Long
    temp = UnhookWindowsHookEx(lpPrevWndProc)
    IsHooked = False
End Sub


Public Function CBTProc(ByVal uCode As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    If uCode < 0 Then
        CBTProc = CallNextHookEx(lpPrevWndProc, uCode, wParam, lParam)
    Else
        'In some cases the lParam is going to be a pointer to a struct and in some cases it will be a long integer
        
        Select Case uCode
            Case HCBT_ACTIVATE
                'wParam == Specifies the handle to the window about to be activated
                'lParam == Pointer to the CBTACTIVATESTRUCT struct
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_ACTIVATE    wParam:" & wParam & vbNewLine
            Case HCBT_CLICKSKIPPED
                'wParam == Specifies the mouse message removed from the system message queue
                'lParam == Pointer to the MOUSEHOOKSTRUCT struct
                '!!!  Commented out to lessen the amount of info to display
                'Form2.Text1.Text = Form2.Text1.Text & "HCBT_CLICKSKIPPED    wParam:" & wParam & vbNewLine
            Case HCBT_CREATEWND
                'wParam == Specifies the handle to the new window
                'lParam == Pointer to the CBT_CREATEWND struct
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_CREATEWND    wParam:" & wParam & "    lParam:" & lParam & vbNewLine
                
                Exit Function '??? creates a GPF in the CallNextHookEx function
                
            Case HCBT_DESTROYWND
                'wParam == Specifies the handle to the window about to be destroyed
                'lParam == 0
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_DESTROYWND    wParam:" & wParam & vbNewLine
            Case HCBT_KEYSKIPPED
                'wParam == Specifies the virtual-key code
                'lParam == Specifies the repeat count, scan code, key-transition code, previous key state, and context code
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_KEYSKIPPED    wParam:" & wParam & "    lParam:" & lParam & vbNewLine
            Case HCBT_MINMAX
                'wParam == Specifies the handle to the window being minimized or maximized
                'lParam == Specifies, in the low-order word, a show-window value (SW_) specifying the operation, The high order word is undefined
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_MINMAX    wParam:" & wParam & "    lParam:" & lParam & vbNewLine
            Case HCBT_MOVESIZE
                'wParam == Specifies the handle to the window to be moved or sized
                'lParam == Pointer to a RECT struct
                'Form2.Text1.Text = Form2.Text1.Text & "HCBT_MOVESIZE    wParam:" & wParam & vbNewLine
            Case HCBT_QS
                'wParam == 0
                'lParam == 0
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_QS" & vbNewLine
            Case HCBT_SETFOCUS
                'wParam == Specifies the handle to the window gaining the keyboard focus
                'lParam == Specifies the handle to the window losing the keyboard focus
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_SETFOCUS    wParam:" & wParam & "    lParam:" & lParam & vbNewLine
            Case HCBT_SYSCOMMAND
                'wParam == Specifies a system-command value (SC_) specifying the system command
                'lParam == Contains the same data as the lParam value of a WM_SYSCOMMAND message
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_SYSCOMMAND    wParam:" & wParam & "    lParam:" & lParam & vbNewLine
            Case Else
                Form2.Text1.Text = Form2.Text1.Text & "HCBT_???" & vbNewLine
        End Select
        
            
        CBTProc = CallNextHookEx(lpPrevWndProc, uCode, wParam, lParam)
    End If
End Function




'-----------------------------
' SET DEBUG FILTER HOOK
'-----------------------------
Public Sub SetDebugHook()
    If IsDBGHooked Then
        MsgBox "Don't hook it twice without unhooking, or you will be unable to unhook it."
    Else
        lpPrevDBGWndProc = SetWindowsHookEx(WH_DEBUG, AddressOf DebugProc, 0, App.ThreadID)

        IsDBGHooked = True
        
        
        'PROBLEM: FIXED by using app.hinstance
        'A global hook is being set with a NULL hInstance parameter
        '   or a thread-specific hook is being set for a thread
        '   that is not in the setting application.
    End If
End Sub

Public Sub RemoveDebugHook()
    Dim temp As Long
    temp = UnhookWindowsHookEx(lpPrevDBGWndProc)
    IsDBGHooked = False
End Sub


Public Function DebugProc(ByVal uCode As Long, ByVal wParam As Long, lParam As DEBUGHOOKINFO) As Long
    
    'If nCode is HC_ACTION, the hook procedure must process the message
    
    If uCode < 0 Then
        DebugProc = CallNextHookEx(lpPrevDBGWndProc, uCode, wParam, lParam)
    Else
        Select Case wParam
            Case WH_CALLWNDPROC
                Form2.Text1.Text = Form2.Text1.Text & "WH_CALLWNDPROC    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_CBT
                Form2.Text1.Text = Form2.Text1.Text & "WH_CBT    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_DEBUG
                Form2.Text1.Text = Form2.Text1.Text & "WH_DEBUG    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_FOREGROUNDIDLE
                Form2.Text1.Text = Form2.Text1.Text & "WH_FOREGROUNDIDLE    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_GETMESSAGE
                Form2.Text1.Text = Form2.Text1.Text & "WH_GETMESSAGE    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_HARDWARE
                Form2.Text1.Text = Form2.Text1.Text & "WH_HARDWARE    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_JOURNALPLAYBACK
                Form2.Text1.Text = Form2.Text1.Text & "WH_JOURNALPLAYBACK    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
    '        This will fire too many times to be of use
    '        Why does this fire - no journal hook has been installed
            Case WH_JOURNALRECORD
    '            Form2.Text1.Text = Form2.Text1.Text & "WH_JOURNALRECORD" & vbNewLine
            Case WH_KEYBOARD
                Form2.Text1.Text = Form2.Text1.Text & "WH_KEYBOARD    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_MAX
                Form2.Text1.Text = Form2.Text1.Text & "WH_MAX    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_MIN
    '            Form2.Text1.Text = Form2.Text1.Text & "WH_MIN    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
    '        This will fire too many times to be of use
            Case WH_MOUSE
    '            Form2.Text1.Text = Form2.Text1.Text & "WH_MOUSE    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_MSGFILTER
                Form2.Text1.Text = Form2.Text1.Text & "WH_MSGFILTER    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_SHELL
                Form2.Text1.Text = Form2.Text1.Text & "WH_SHELL    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case WH_SYSMSGFILTER
                Form2.Text1.Text = Form2.Text1.Text & "WH_SYSMSGFILTER    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
            Case Else
    '           This will fire too many times to be of use
                'Form2.Text1.Text = Form2.Text1.Text & "else    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
        End Select
        
            
        'To prevent the system from calling the hook, the hook procedure must return a nonzero value
        DebugProc = CallNextHookEx(lpPrevDBGWndProc, uCode, wParam, lParam)
    End If
End Function







